/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.structurize.network.messages;

import com.ldtteam.structurize.Network;
import com.ldtteam.structurize.client.gui.WindowBuildTool;
import com.ldtteam.structurize.client.gui.WindowShapeTool;
import com.ldtteam.structurize.helpers.Settings;
import com.ldtteam.structurize.management.linksession.ChannelsEnum;
import com.ldtteam.structurize.management.linksession.LinkSessionManager;
import com.ldtteam.structurize.network.messages.IMessage;
import java.util.Set;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.Nullable;

public class LSStructureDisplayerMessage
implements IMessage {
    private final CompoundTag settings;
    private final boolean show;

    public LSStructureDisplayerMessage(FriendlyByteBuf buf) {
        this.show = buf.readBoolean();
        this.settings = this.show ? buf.m_130260_() : null;
    }

    public LSStructureDisplayerMessage(CompoundTag compoundNBT, boolean show) {
        this.settings = compoundNBT;
        this.show = show;
    }

    @Override
    public void toBytes(FriendlyByteBuf buf) {
        buf.writeBoolean(this.show);
        if (this.show) {
            buf.m_130079_(this.settings);
        }
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return null;
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (isLogicalServer) {
            ServerPlayer player = ctxIn.getSender();
            if (LinkSessionManager.INSTANCE.getMuteState(player.m_142081_(), ChannelsEnum.STRUCTURE_DISPLAYER)) {
                return;
            }
            Set<UUID> targets = LinkSessionManager.INSTANCE.execute(player.m_142081_(), ChannelsEnum.STRUCTURE_DISPLAYER);
            targets.remove(player.m_142081_());
            for (UUID target : targets) {
                ServerPlayer playerEntity = player.m_20194_().m_6846_().m_11259_(target);
                if (playerEntity == null) continue;
                Network.getNetwork().sendToPlayer(new LSStructureDisplayerMessage(this.settings, this.show), playerEntity);
            }
        } else if (this.show) {
            Settings.instance.deserializeNBT(this.settings);
            if (Settings.instance.getStructureName() == null && Settings.instance.getStaticSchematicName() == null) {
                WindowShapeTool.commonStructureUpdate();
            } else {
                WindowBuildTool.commonStructureUpdate();
            }
        } else {
            Settings.instance.reset();
        }
    }
}

